#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=TTR.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Description=d3monCorp
#AutoIt3Wrapper_Res_Fileversion=0.0.0.1
#AutoIt3Wrapper_Res_LegalCopyright=d3mon Corporation. All rights reserved.
#AutoIt3Wrapper_Run_Obfuscator=y
#Obfuscator_Parameters=/striponly
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#include 'GUICtrlSetOnHover_UDF.au3'
#include 'ID3.au3'
#include 'IsPressed_UDF.au3'
#include <Sound.au3>
;

Opt('GUIOnEventMode', 1)
Local $f_music, $init, $length, $f_fd, $t_init = 401, $s_artist, $s_title
Local $s_dir = @TempDir & '\Tap_Maker\'
Local $b_Record = -1, $s_level = 1
Local $f_tmp = @TempDir & '\tmp.tap'
$f_snd = _SoundOpen('menu_slide.wav')

DirCreate(@TempDir & '\Tap_Maker')
FileInstall('7-zip32.dll', $s_dir & '7-zip32.dll')
FileInstall('Tap_Maker.zip', $s_dir & 'Tap_Maker.zip')
_7ZIPExtract(0, $s_dir & 'Tap_Maker.zip', @TempDir & '\Tap_Maker', 1)

#Region GUI
$GUI = GUICreate('Tap Maker', 360, 685, -1, -1, 0x80000000)
GUISetOnEvent(-3, '_Exit')
GUISetOnEvent(-9, '_Move')

GUICtrlCreatePic($s_dir & 'iphone.jpg', 0, 0, 360, 685, 128)

$p_hm = GUICtrlCreatePic($s_dir & 'home.bmp', 156, 79, 46, 30)
GUICtrlSetOnEvent($p_hm, '_Home')
GUICtrlSetTip($p_hm, 'Return to home screen')
GUICtrlSetState($p_hm, 32)

;Region 1
$p_tt = GUICtrlCreatePic($s_dir & 'TapTap_Maker.jpg', 20, 117, 320, 460, 128)

$p_st = GUICtrlCreatePic($s_dir & 'Start-n.jpg', 38, 467, 286, 48)
GUICtrlSetOnHover($p_st, '_Hover', '_NoHover')
GUICtrlSetOnEvent(-1, '_Start')

;Region 2
$p_bg = GUICtrlCreatePic($s_dir & 'bg_Record.jpg', 20, 117, 320, 460, 128)
GUICtrlSetState($p_bg, 32)

$l_fn = GUICtrlCreateLabel("", 40, 137, 295, 22)
_SetAttrib(-1, 14)
GUICtrlSetState($l_fn, 32)

$l_at = GUICtrlCreateLabel('Artist :', 40, 162, 45, 20)
_SetAttrib(-1, 12)
GUICtrlSetState($l_at, 32)

$e_at = GUICtrlCreateEdit("", 90, 164, 230, 17, 128)
GUICtrlSetState($e_at, 32)

$l_ti = GUICtrlCreateLabel('Title :', 40, 182, 40, 20)
_SetAttrib(-1, 12)
GUICtrlSetState($l_ti, 32)

$e_ti = GUICtrlCreateEdit("", 90, 184, 230, 17, 128)
GUICtrlSetState($e_ti, 32)


$l_ln = GUICtrlCreateLabel("", 40, 207, 295, 20)
_SetAttrib(-1, 14)
GUICtrlSetState($l_ln, 32)

$p_pl = GUICtrlCreatePic($s_dir & 'Play.bmp', 157, 485, 50, 50)
GUICtrlSetOnHover($p_pl, '_Hover', '_NoHover')
GUICtrlSetOnEvent($p_pl, '_Record')
GUICtrlSetState($p_pl, 32)
GUICtrlSetTip($p_pl, 'Start recording !')

$b_rc = GUICtrlCreatePic($s_dir & 'Record-n.bmp', 120, 533, 115, 27)
GUICtrlSetState($b_rc, 32)

;Region 3
$p_ap = GUICtrlCreatePic($s_dir & 'Background.jpg', 20, 117, 320, 460, 128)
GUICtrlSetState($p_ap, 32)

$p_Ls = GUICtrlCreatePic($s_dir & 'L_Sparkle.bmp', 24, 490, 40, 40)
GUICtrlSetState($p_Ls, 32)
$p_Ms = GUICtrlCreatePic($s_dir & 'M_Sparkle.bmp', 160, 490, 40, 40)
GUICtrlSetState($p_Ms, 32)
$p_Rs = GUICtrlCreatePic($s_dir & 'R_Sparkle.bmp', 296, 490, 40, 40)
GUICtrlSetState($p_Rs, 32)

$p_Lh = GUICtrlCreatePic($s_dir & 'L_Shake.bmp', 24, 480, 45, 32)
GUICtrlSetState($p_Lh, 32)
$p_Mh = GUICtrlCreatePic($s_dir & 'M_Shake.bmp', 159, 460, 42, 75)
GUICtrlSetState($p_Mh, 32)
$p_Rh = GUICtrlCreatePic($s_dir & 'R_Shake.bmp', 292, 482, 45, 32)
GUICtrlSetState($p_Rh, 32)

$l_rm = GUICtrlCreateLabel("", 45, 137, 180, 22)
_SetAttrib(-1, 14)

$l_st = GUICtrlCreateLabel("", 280, 137, 40, 22)
_SetAttrib(-1, 14)

;Region 4
$p_di = GUICtrlCreatePic($s_dir & 'Difficulty.jpg', 20, 117, 320, 460, 128)
GUICtrlSetState($p_di, 32)

$b_ed = GUICtrlCreatePic($s_dir & 'E_Difficulty.jpg', 35, 240, 288, 48)
GUICtrlSetOnEvent($b_ed, '_Easy_Check')
GUICtrlSetState($b_ed, 32)

$b_md = GUICtrlCreatePic($s_dir & 'M_Difficulty.jpg', 35, 288, 288, 48)
GUICtrlSetOnEvent($b_md, '_Meddium_Check')
GUICtrlSetState($b_md, 32)

$b_hd = GUICtrlCreatePic($s_dir & 'H_Difficulty.jpg', 35, 336, 288, 48)
GUICtrlSetOnEvent($b_hd, '_Hard_Check')
GUICtrlSetState($b_hd, 32)

$b_xd = GUICtrlCreatePic($s_dir & 'X_Difficulty.jpg', 35, 384, 288, 48)
GUICtrlSetOnEvent($b_xd, '_Extreme_Check')
GUICtrlSetState($b_xd, 32)

$p_ed = GUICtrlCreatePic($s_dir & 'E_Difficulty.bmp', 266, 252, 28, 27)
GUICtrlSetState($p_ed, 32)

$p_md = GUICtrlCreatePic($s_dir & 'M_Difficulty.bmp', 266, 300, 28, 27)
GUICtrlSetState($p_md, 32)

$p_hd = GUICtrlCreatePic($s_dir & 'H_Difficulty.bmp', 266, 347, 28, 27)
GUICtrlSetState($p_hd, 32)

$p_xd = GUICtrlCreatePic($s_dir & 'X_Difficulty.bmp', 266, 395, 28, 27)
GUICtrlSetState($p_xd, 32)

$p_ct = GUICtrlCreatePic($s_dir & 'CreateTap-n.jpg', 35, 495, 286, 48)
GUICtrlSetOnHover($p_ct, '_Hover', '_NoHover')
GUICtrlSetOnEvent($p_ct, '_CreateTap')
GUICtrlSetState($p_ct, 32)

_GuiRoundCorners($GUI, 0, 0, 124, 124)

DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $GUI, 'int', 500, 'long', 0x00080000)
GUISetState(@SW_SHOW, $GUI)
#EndRegion
;

While Sleep(100)
	If $b_Record = 1 Then
		$s_Sec = StringLeft(TimerDiff($init), StringInStr(TimerDiff($init), '.') -1)
		If TimerDiff($t_init) > 400 Then
			GUICtrlSetData($l_rm, 'Remaining : ' & _ExTicksToTime($length - $s_Sec))
			$t_init = TimerInit( )
		EndIf
		If _IsAndKeyPressed('11|25') Then
			GUICtrlSetState($p_Lh, 16)
			While _IsAndKeyPressed('11|25')
				Sleep(50)
			WEnd
			FileWrite($f_tmp, @CRLF & '52.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) & ', 1')
			GUICtrlSetState($p_Lh, 32)
		ElseIf _IsAndKeyPressed('11|28') Then
			GUICtrlSetState($p_Mh, 16)
			While _IsAndKeyPressed('11|28')
				Sleep(50)
			WEnd
			FileWrite($f_tmp, @CRLF & '160.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) & ', 2')
			GUICtrlSetState($p_Mh, 32)
		ElseIf _IsAndKeyPressed('11|27') Then
			GUICtrlSetState($p_Rh, 16)
			While _IsAndKeyPressed('11|27')
				Sleep(50)
			WEnd
			FileWrite($f_tmp, @CRLF & '271.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) & ', 3')
			GUICtrlSetState($p_Rh, 32)
		ElseIf _IsAndKeyPressed('25|28|27') Then
			GUICtrlSetState($p_Ls, 16)
			GUICtrlSetState($p_Ms, 16)
			GUICtrlSetState($p_Rs, 16)
			While _IsAndKeyPressed('25|28|27')
				Sleep(50)
			WEnd
			FileWrite($f_tmp, @CRLF & '52.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) & ', 0')
			FileWrite($f_tmp, @CRLF & '160.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) + 0.05 & ', 0')
			FileWrite($f_tmp, @CRLF & '271.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) + 0.10 & ', 0')
			GUICtrlSetState($p_Ls, 32)
			GUICtrlSetState($p_Ms, 32)
			GUICtrlSetState($p_Rs, 32)
		ElseIf _IsAndKeyPressed('25|28') Then
			GUICtrlSetState($p_Ls, 16)
			GUICtrlSetState($p_Ms, 16)
			While _IsAndKeyPressed('25|28')
				Sleep(50)
			WEnd
			FileWrite($f_tmp, @CRLF & '52.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) & ', 0')
			FileWrite($f_tmp, @CRLF & '160.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) + 0.05 & ', 0')
			GUICtrlSetState($p_Ls, 32)
			GUICtrlSetState($p_Ms, 32)
		ElseIf _IsAndKeyPressed('28|27') Then
			GUICtrlSetState($p_Ms, 16)
			GUICtrlSetState($p_Rs, 16)
			While _IsAndKeyPressed('28|27')
				Sleep(50)
			WEnd
			FileWrite($f_tmp, @CRLF & '160.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) & ', 0')
			FileWrite($f_tmp, @CRLF & '271.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) + 0.05 & ', 0')
			GUICtrlSetState($p_Ms, 32)
			GUICtrlSetState($p_Rs, 32)
		ElseIf _IsAndKeyPressed('25|27') Then
			GUICtrlSetState($p_Ls, 16)
			GUICtrlSetState($p_Rs, 16)
			While _IsAndKeyPressed('25|27')
				Sleep(50)
			WEnd
			FileWrite($f_tmp, @CRLF & '52.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) & ', 0')
			FileWrite($f_tmp, @CRLF & '271.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) + 0.05 & ', 0')
			GUICtrlSetState($p_Ls, 32)
			GUICtrlSetState($p_Rs, 32)
		ElseIf _IsPressed('25') Then
			GUICtrlSetState($p_Ls, 16)
			While _IsPressed('25')
				Sleep(50)
			WEnd
			FileWrite($f_tmp, @CRLF & '52.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) & ', 0')
			GUICtrlSetState($p_Ls, 32)
		ElseIf _IsPressed('28') Then
			GUICtrlSetState($p_Ms, 16)
			While _IsPressed('28')
				Sleep(50)
			WEnd
			FileWrite($f_tmp, @CRLF & '160.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) & ', 0')
			GUICtrlSetState($p_Ms, 32)
		ElseIf _IsPressed('27') Then
			GUICtrlSetState($p_Rs, 16)
			While _IsPressed('27')
				Sleep(50)
			WEnd
			FileWrite($f_tmp, @CRLF & '271.000000, 400.000000, ' & StringFormat("%.6f", TimerDiff($init) / 1000) & ', 0')
			GUICtrlSetState($p_Rs, 32)
		EndIf
		If TimerDiff($init) > $length Then
			_EndRecord( ) ;End of recording music
		EndIf
		GUICtrlSetData($l_st, _FileCountLines($f_tmp) -3)
	EndIf
WEnd

Func _SetAttrib($CtrlID, $Size)
	GUICtrlSetColor($CtrlID, 0xFFFFFF)
	GUICtrlSetFont($CtrlID, $Size)
	GUICtrlSetBkColor($CtrlID, -2)
EndFunc

Func _Start( )
	GUICtrlSetImage($p_st, 'Start-p.jpg')
	While _IsPressed('01')
		Sleep(100)
	WEnd
	GUICtrlSetImage($p_st, 'Start-n.jpg')
	$f_br = _Browse( )
	If $f_br = -1 Then Return ;Nothing
	_SoundPlay($f_snd)
	GUICtrlSetState($p_st, 32)
	GUICtrlSetState($p_tt, 32)
	
	GUICtrlSetState($p_hm, 16)
	GUICtrlSetState($p_bg, 16)
	GUICtrlSetState($p_pl, 16)
	GUICtrlSetState($b_rc, 16)
	GUICtrlSetState($l_fn, 16)
	GUICtrlSetState($l_at, 16)
	GUICtrlSetState($l_ti, 16)
	GUICtrlSetState($e_at, 16)
	GUICtrlSetState($e_ti, 16)
	GUICtrlSetState($l_ln, 16)
EndFunc

Func _Browse( )
	$f_fd = FileOpenDialog('Select a music file to open...', @MyDocumentsDir, 'Music (*.mp3)', 3, "", $GUI)
	If @error Then Return -1
	$f_gn = StringTrimRight(StringTrimLeft($f_fd, StringInStr($f_fd, '\', 0, -1)), 4)
	GUICtrlSetData($l_fn, 'File name : ' & $f_gn)
	_ID3ReadTag($f_fd)
	_ID3DeleteFiles( )
	$f_music = _SoundOpen($f_fd)
	GUICtrlSetData($e_at, _ID3GetTagField("TPE1"))
	GUICtrlSetData($e_ti, _ID3GetTagField("TIT2"))
	GUICtrlSetData($l_ln, 'Length : ' & _SoundLength($f_music))
EndFunc

Func _Record( )
	GUICtrlSetImage($b_rc, 'Record-p.bmp')
	_SoundPlay($f_snd)
	While _IsPressed('01')
		Sleep(100)
	WEnd
	GUICtrlSetState($p_pl, 32)
	GUICtrlSetState($b_rc, 32)
	GUICtrlSetState($l_fn, 32)
	GUICtrlSetState($l_at, 32)
	GUICtrlSetState($l_ti, 32)
	GUICtrlSetState($e_at, 32)
	GUICtrlSetState($e_ti, 32)
	GUICtrlSetState($l_ln, 32)
	GUICtrlSetState($p_bg, 32)
	
	GUICtrlSetState($p_ap, 16)
	GUICtrlSetState($l_rm, 16)
	GUICtrlSetState($l_st, 16)
	
	$length = _SoundLength($f_music, 2)
	_SoundPlay($f_music)
	$init = TimerInit( )
	
	#Region Music Infos
	$s_title = GUICtrlRead($e_ti)
	FileDelete($f_tmp)
	FileWrite($f_tmp, '#title ' & $s_title)
	
	$s_artist = GUICtrlRead($e_at)
	FileWrite($f_tmp, @CRLF & '#artist ' & $s_artist)
	
	FileWrite($f_tmp, @CRLF & '#id ' & Random(10000, 90000, 1))
	#EndRegion
	$b_Record = 1
EndFunc

Func _EndRecord( )
	_SoundClose($f_music)
	_SoundPlay($f_snd)
	$b_Record = -1
	
	GUICtrlSetState($p_ap, 32)
	GUICtrlSetState($l_rm, 32)
	GUICtrlSetState($l_st, 32)
	
	GUICtrlSetState($p_di, 16)
	GUICtrlSetState($b_ed, 16)
	GUICtrlSetState($b_md, 16)
	GUICtrlSetState($b_hd, 16)
	GUICtrlSetState($b_xd, 16)
	GUICtrlSetState($p_ed, 16)
	GUICtrlSetState($p_ct, 16)
EndFunc

Func _CreateTap( )
	FileWrite($f_tmp, @CRLF) ;End of music line
	FileMove($f_tmp, @DesktopDir & '\' & $s_artist & " - " & $s_title & $s_level &'.tap', 1)
	FileCopy($f_fd, @DesktopDir & '\' & $s_artist & " - " & $s_title & '.m4a', 1)
	
	MsgBox(64, 'Tap Maker', 'Done !' & @CRLF & 'Music and .tap file placed on your desktop !')
	_SoundPlay($f_snd)
	
	GUICtrlSetState($p_di, 32)
	GUICtrlSetState($b_ed, 32)
	GUICtrlSetState($b_md, 32)
	GUICtrlSetState($b_hd, 32)
	GUICtrlSetState($b_xd, 32)
	GUICtrlSetState($p_ed, 32)
	GUICtrlSetState($p_ct, 32)
	GUICtrlSetState($p_ap, 32)
	GUICtrlSetState($p_hm, 32)
	_Home( )
EndFunc

Func _Easy_Check( )
	GUICtrlSetState($p_ed, 16)
	GUICtrlSetState($p_md, 32)
	GUICtrlSetState($p_hd, 32)
	GUICtrlSetState($p_xd, 32)
	$s_level = ' (easy)'
EndFunc

Func _Meddium_Check( )
	GUICtrlSetState($p_ed, 32)
	GUICtrlSetState($p_md, 16)
	GUICtrlSetState($p_hd, 32)
	GUICtrlSetState($p_xd, 32)
	$s_level = ' (meddium)'
EndFunc

Func _Hard_Check( )
	GUICtrlSetState($p_ed, 32)
	GUICtrlSetState($p_md, 32)
	GUICtrlSetState($p_hd, 16)
	GUICtrlSetState($p_xd, 32)
	$s_level = ' (hard)'
EndFunc


Func _Extreme_Check( )
	GUICtrlSetState($p_ed, 32)
	GUICtrlSetState($p_md, 32)
	GUICtrlSetState($p_hd, 32)
	GUICtrlSetState($p_xd, 16)
	$s_level = ' (extreme)'
EndFunc

Func _Exit( )
	_SoundClose($f_music)
	_SoundClose($f_snd)
	DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $GUI, 'int', 500, 'long', 0x00090000)
	Exit DirRemove(@TempDir & '\Tap_Maker', 1)
EndFunc

Func _Hover($iCtrl)
	Switch $iCtrl
		Case $p_st
			GUICtrlSetImage($p_st, 'Start-h.jpg')
		Case $p_pl
			GUICtrlSetImage($b_rc, 'Record-h.bmp')
	EndSwitch
EndFunc

Func _NoHover($iCtrl)
	Switch $iCtrl
		Case $p_st
			GUICtrlSetImage($p_st, 'Start-n.jpg')
		Case $p_pl
			GUICtrlSetImage($b_rc, 'Record-n.bmp')
	EndSwitch
EndFunc

Func _Home( )
	_SoundClose($f_music)
	_SoundPlay($f_snd)
	$b_Record = -1
	
	GUICtrlSetState($p_pl, 32)
	GUICtrlSetState($b_rc, 32)
	GUICtrlSetState($l_fn, 32)
	GUICtrlSetState($l_at, 32)
	GUICtrlSetState($l_ti, 32)
	GUICtrlSetState($e_at, 32)
	GUICtrlSetState($e_ti, 32)
	GUICtrlSetState($l_ln, 32)
	GUICtrlSetState($p_bg, 32)
	GUICtrlSetState($p_ap, 32)
	GUICtrlSetState($l_rm, 32)
	GUICtrlSetState($l_st, 32)
	GUICtrlSetState($p_di, 32)
	GUICtrlSetState($b_ed, 32)
	GUICtrlSetState($b_md, 32)
	GUICtrlSetState($b_hd, 32)
	GUICtrlSetState($b_xd, 32)
	GUICtrlSetState($p_ed, 32)
	GUICtrlSetState($p_md, 32)
	GUICtrlSetState($p_hd, 32)
	GUICtrlSetState($p_xd, 32)
	
	GUICtrlSetState($p_tt, 16)
	GUICtrlSetState($p_st, 16)
EndFunc

Func _ExTicksToTime($iTicks)
	If Number($iTicks) > 0 Then
		$iTicks = Round($iTicks / 1000)
		$iHour = Int($iTicks / 3600)
		$iTicks = Mod($iTicks, 3600)
		$iMin = Int($iTicks / 60)
		$iSec = Round(Mod($iTicks, 60))
		Return StringFormat("%02i:%02i:%02i", $iHour, $iMin, $iSec)
	ElseIf Number($iTicks) = 0 Then
		Return "00:00:00"
	EndIf
EndFunc

Func _GuiRoundCorners($h_win, $i_x1, $i_y1, $i_x3, $i_y3)
   Local $pos = WinGetPos($h_win)
   $ret = DllCall("gdi32.dll", "long", "CreateRoundRectRgn", "long", $i_x1, "long", $i_y1, "long", $pos[2], "long", $pos[3], "long", $i_x3, "long", $i_y3)
   If $ret[0] Then $ret2 = DllCall("user32.dll", "long", "SetWindowRgn", "hwnd", $h_win, "long", $ret[0], "int", 1)
EndFunc

Func _Move( )
	DllCall('user32.dll', 'int', _
			'SendMessage', 'hWnd', $GUI, _
			'int', 0x00A1, 'int', 2, 'int', 0)
EndFunc


; #FUNCTION# ====================================================================================================================
; Name...........: _7ZIPExtract
; Author ........: R. Gilman (rasim)
; ===============================================================================================================================
Func _7ZIPExtract($hWnd, $sArcName, $sOutput = 0, $sHide = 0, $sOverwrite = 0, $sRecurse = 1, $sIncludeArc = 0, $sExcludeArc = 0, _
				  $sIncludeFile = 0, $sExcludeFile = 0, $sPassword = 0, $sYes = 0)
	
	$sArcName = '"' & $sArcName & '"'
	
	Local $iSwitch = ""
	
	If $sOutput Then $iSwitch = ' -o"' & $sOutput & '"'
	If $sHide Then $iSwitch &= " -hide"
	
	$iSwitch &= _OverwriteSet($sOverwrite)
	$iSwitch &= _RecursionSet($sRecurse)
	
	If $sIncludeArc Then $iSwitch &= _IncludeArcSet($sIncludeArc)
	If $sExcludeArc Then $iSwitch &= _ExcludeArcSet($sExcludeArc)
	
	If $sIncludeFile Then $iSwitch &= _IncludeFileSet($sIncludeFile)
	If $sExcludeFile Then $iSwitch &= _ExcludeFileSet($sExcludeFile)
	
	If $sPassword Then $iSwitch &= " -p" & $sPassword
	If $sYes Then $iSwitch &= " -y"
	
	Local $tOutBuffer = DllStructCreate("char[32768]")
	
	Local $hDLL_7ZIP = DllOpen($s_dir & '7-zip32.dll')
	Local $aRet = DllCall($hDLL_7ZIP, "int", "SevenZip", _
											 "hwnd", $hWnd, _
											 "str", "e " & $sArcName & " " & $iSwitch, _
											 "ptr", DllStructGetPtr($tOutBuffer), _
											 "int", DllStructGetSize($tOutBuffer))
	
	DllClose($hDLL_7ZIP)
	If Not $aRet[0] Then Return SetError(0, 0, DllStructGetData($tOutBuffer, 1))
	Return SetError(1, 0, 0)
EndFunc   ;==>_7ZIPExtract

Func _RecursionSet($sVal)
	Switch $sVal
		Case 1
			Return " -r"
		Case 2
			Return " -r0"
		Case Else
			Return " -r-"
	EndSwitch
EndFunc   ;==>_RecursionSet

Func _IncludeFileSet($sVal)
	If StringInStr($sVal, "*") Then
		Return ' -i!"' & $sVal & '"'
	ElseIf StringLeft($sVal, 1) = "@" Then
		Return ' -i"' & $sVal  & '"'
	Else
		Return ' -i!"' & $sVal & '"'
	EndIf
EndFunc   ;==>_IncludeFileSet

Func _ExcludeFileSet($sVal)
	If StringInStr($sVal, "*") Then
		Return ' -x!"' & $sVal & '"'
	ElseIf StringLeft($sVal, 1) = "@" Then
		Return ' -x"' & $sVal & '"'
	Else
		Return ' -x!"' & $sVal & '"'
	EndIf
EndFunc   ;==>_ExcludeFileSet

Func _OverwriteSet($sVal)
	Switch $sVal
		Case 0
			Return " -aoa"
		Case 1
			Return " -aos"
		Case 2
			Return " -aou"
		Case 3
			Return " -aot"
		Case Else
			Return " -aoa"
	EndSwitch
EndFunc   ;==>_OverwriteSet

Func _IncludeArcSet($sVal)
	If StringInStr($sVal, "*") Then
		Return ' -ai!"' & $sVal & '"'
	ElseIf StringLeft($sVal, 1) = "@" Then
		Return ' -ai"' & $sVal & '"'
	Else
		Return ' -ai!"' & $sVal & '"'
	EndIf
EndFunc   ;==>_IncludeArcSet

Func _ExcludeArcSet($sVal)
	If StringInStr($sVal, "*") Then
		Return ' -ax!"' & $sVal & '"'
	ElseIf StringLeft($sVal, 1) = "@" Then
		Return ' -ax"' & $sVal & '"'
	Else
		Return ' -ax!"' & $sVal & '"'
	EndIf
EndFunc   ;==>_ExcludeArcSet